/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.Event;
import org.joda.time.DateTime;

public class EventReader
extends Reader<Event> {
    private final String pathWorkspaceSid;
    private DateTime endDate;
    private String eventType;
    private Integer minutes;
    private String reservationSid;
    private DateTime startDate;
    private String taskQueueSid;
    private String taskSid;
    private String workerSid;
    private String workflowSid;

    public EventReader(String pathWorkspaceSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
    }

    public EventReader setEndDate(DateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public EventReader setEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public EventReader setMinutes(Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    public EventReader setReservationSid(String reservationSid) {
        this.reservationSid = reservationSid;
        return this;
    }

    public EventReader setStartDate(DateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public EventReader setTaskQueueSid(String taskQueueSid) {
        this.taskQueueSid = taskQueueSid;
        return this;
    }

    public EventReader setTaskSid(String taskSid) {
        this.taskSid = taskSid;
        return this;
    }

    public EventReader setWorkerSid(String workerSid) {
        this.workerSid = workerSid;
        return this;
    }

    public EventReader setWorkflowSid(String workflowSid) {
        this.workflowSid = workflowSid;
        return this;
    }

    @Override
    public ResourceSet<Event> read(TwilioRestClient client) {
        return new ResourceSet<Event>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Event> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.pathWorkspaceSid + "/Events", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Event> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Event> nextPage(Page<Event> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TASKROUTER.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Event> previousPage(Page<Event> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.TASKROUTER.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Event> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Event read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("events", response.getContent(), Event.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate.toString());
        }
        if (this.eventType != null) {
            request.addQueryParam("EventType", this.eventType);
        }
        if (this.minutes != null) {
            request.addQueryParam("Minutes", this.minutes.toString());
        }
        if (this.reservationSid != null) {
            request.addQueryParam("ReservationSid", this.reservationSid);
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate.toString());
        }
        if (this.taskQueueSid != null) {
            request.addQueryParam("TaskQueueSid", this.taskQueueSid);
        }
        if (this.taskSid != null) {
            request.addQueryParam("TaskSid", this.taskSid);
        }
        if (this.workerSid != null) {
            request.addQueryParam("WorkerSid", this.workerSid);
        }
        if (this.workflowSid != null) {
            request.addQueryParam("WorkflowSid", this.workflowSid);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

